import requests
import json
import typing

from Deadline.Scripting import ClientUtils, MonitorUtils, RepositoryUtils
from Deadline.Jobs import Job, JobStatus

from DeadlineUI.Controls.Scripting.DeadlineScriptDialog import DeadlineScriptDialog
from ThinkboxUI.Controls.Scripting.ButtonControl import ButtonControl

def __main__():
    global scriptDialog

    scriptDialog = RestartDialog()
    # Add control buttons
    scriptDialog.AddGrid()
    scriptDialog.AddHorizontalSpacerToGrid( "HSpacer", 0, 0 )
    okButton = scriptDialog.AddControlToGrid( "OkButton", "ButtonControl", "Yes", 0, 1, expand=False )
    okButton.clicked.connect( OKButtonClicked )
    cancelButton = scriptDialog.AddControlToGrid( "CancelButton", "ButtonControl", "No", 0, 2, expand=False )
    cancelButton.clicked.connect( CancelButtonClicked )
    scriptDialog.EndGrid()
    scriptDialog.ShowDialog( True )

def OKButtonClicked():
    # type: () -> None
    super( RestartDialog, scriptDialog ).accept()

    try:
        selectedTasks = MonitorUtils.GetSelectedTasks()
        task = selectedTasks[0]
        jobId = task.TaskJobId
        taskJob = RepositoryUtils.GetJob(jobId, True)

        print("TaskId: %s" % task.TaskId)
        print("JobId: %s" % taskJob.ExtraInfo1)
        print("ProjectId: %s" % taskJob.ExtraInfo0)
        RestartGridMarketsTask(task, taskJob)
    except Exception as e:
        super( RestartDialog, scriptDialog ).ShowMessageBox( "Error restarting task: %s" % str(e), "Error" )

def CancelButtonClicked():
    # type: () -> None
    super( RestartDialog, scriptDialog ).reject()

def RestartGridMarketsTask(task, job):
    gmTaskId = task.TaskId
    gmJobId = job.ExtraInfo1
    gmProjectId = job.ExtraInfo0

    print("Restarting task...")
    url = "http://localhost:8090/submissions/%s/jobs/%s/tasks/%s?action=requeue" % (gmProjectId, gmJobId, gmTaskId)
    headers = {"Content-Type": "application/json"}
    
    try:
        response = requests.post(url, headers=headers)
        if response.status_code == 200 or response.status_code == 201  or response.status_code == 202:
            print(f"Status Code: {response.status_code}")
            print(f"Response: {response.json()}")
            super( RestartDialog, scriptDialog ).ShowMessageBox( "Restarting task", "Info" )
        else:
            if response.status_code == 401:
                raise Exception("Please login to Envoy.")
            else:
                raise Exception(f"{response.json()}")
    except Exception as e:
        print(f"Error restarting task: {str(e)}")
        super( RestartDialog, scriptDialog ).ShowMessageBox( "Error restarting task: %s" % str(e), "Error" )
        

########################################################################
## Subclass of DeadlineScriptDialog for the UI
########################################################################
class RestartDialog( DeadlineScriptDialog ):

    def __init__( self, parentAppName="", parent=None ):
        # type: (str, Optional[Any]) -> None
        super( RestartDialog, self ).__init__( parent )
        self.SetTitle( "Restart Task" )
        self.AddControl( "RestartText", "LabelControl", "Are you sure, do you want to restart this task?", 480, -1 )

    @classmethod
    def ShowMessageBox( cls, message, title="Info" ):
        # type: (str, str) -> None
        if cls is not None:
            ClientUtils.ShowMessageBox( message, title )
        else:
            print( "{}: {}".format( title, message ) )

########################################################################
## Globals
########################################################################
# down here to ensure all functions/classes exist
if typing.TYPE_CHECKING:
    scriptDialog = RestartDialog()
else:
    scriptDialog = None

